#include "BigInteger.h"
#include "../lang/Number.h"
#include "../../org/teavm/runtime/Allocator.h"
#include "../../../arrays/primitives/int.h"
#include "Elementary.h"
#include "BitLevel.h"
#include "../lang/ArithmeticException.h"
#include "../../../strings.h"
#include "../../org/teavm/runtime/ExceptionHandling.h"
#include "Conversion.h"
#include "Multiplication.h"
#include "Division.h"
#include "../../../arrays/classes/java/math/BigInteger.h"
#include "../lang/Comparable.h"
#include "../io/Serializable.h"
#include "../lang/Object.h"

void* sfld_jm_BigInteger_ZERO;
void* sfld_jm_BigInteger_ONE;
void* sfld_jm_BigInteger_TWO;
void* sfld_jm_BigInteger_TEN;
void* sfld_jm_BigInteger_MINUS_ONE;
TeaVM_Array* sfld_jm_BigInteger_SMALL_VALUES;
TeaVM_Array* sfld_jm_BigInteger_TWO_POWS;
void meth_jm_BigInteger__init__0(void* teavm_this_, int32_t teavm_local_1, int32_t teavm_local_2) {
    TeaVM_Array* teavm_local_3;
    TEAVM_ALLOC_STACK(INT32_C(0));
    if ((!(((TeaVM_Class *) &jm_BigInteger_Cls)->flags & INT32_C(1)))) {
        TEAVM_WITH_CALL_SITE_ID(9642, initclass_jm_BigInteger());
    }
    TEAVM_WITH_CALL_SITE_ID(9643, meth_jl_Number__init_(teavm_this_));
    TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_firstNonzeroDigit) = -INT32_C(2);
    TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_sign) = teavm_local_1;
    TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_numberLength) = INT32_C(1);
    teavm_local_3 = TEAVM_WITH_CALL_SITE_ID(9644, meth_otr_Allocator_allocateArray(&Arr_I_Cls, INT32_C(1)));
    TEAVM_ARRAY_AT(teavm_local_3, int32_t, INT32_C(0)) = teavm_local_2;
    teavm_gc_writeBarrier(teavm_this_);
    TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_digits) = teavm_local_3;
    TEAVM_RELEASE_STACK;
}
void meth_jm_BigInteger__init_(void* teavm_this_, int32_t teavm_local_1, int32_t teavm_local_2, TeaVM_Array* teavm_local_3) {
    TEAVM_ALLOC_STACK(INT32_C(0));
    if ((!(((TeaVM_Class *) &jm_BigInteger_Cls)->flags & INT32_C(1)))) {
        TEAVM_WITH_CALL_SITE_ID(9645, initclass_jm_BigInteger());
    }
    TEAVM_WITH_CALL_SITE_ID(9646, meth_jl_Number__init_(teavm_this_));
    TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_firstNonzeroDigit) = -INT32_C(2);
    TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_sign) = teavm_local_1;
    TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_numberLength) = teavm_local_2;
    teavm_gc_writeBarrier(teavm_this_);
    TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_digits) = teavm_local_3;
    TEAVM_RELEASE_STACK;
}
void meth_jm_BigInteger__init__1(void* teavm_this_, int32_t teavm_local_1, int64_t teavm_local_2) {
    TeaVM_Array* teavm_local_3;
    TEAVM_ALLOC_STACK(INT32_C(0));
    if ((!(((TeaVM_Class *) &jm_BigInteger_Cls)->flags & INT32_C(1)))) {
        TEAVM_WITH_CALL_SITE_ID(9647, initclass_jm_BigInteger());
    }
    TEAVM_WITH_CALL_SITE_ID(9648, meth_jl_Number__init_(teavm_this_));
    TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_firstNonzeroDigit) = -INT32_C(2);
    TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_sign) = teavm_local_1;
    if (((teavm_local_2 & -INT64_C(4294967296)) == INT64_C(0))) {
        TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_numberLength) = INT32_C(1);
        teavm_local_3 = TEAVM_WITH_CALL_SITE_ID(9649, meth_otr_Allocator_allocateArray(&Arr_I_Cls, INT32_C(1)));
        TEAVM_ARRAY_AT(teavm_local_3, int32_t, INT32_C(0)) = ((int32_t) teavm_local_2);
        teavm_gc_writeBarrier(teavm_this_);
        TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_digits) = teavm_local_3;
    } else {
        TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_numberLength) = INT32_C(2);
        teavm_local_3 = TEAVM_WITH_CALL_SITE_ID(9650, teavm_fillIntArray(meth_otr_Allocator_allocateArray(&Arr_I_Cls, 2), ((int32_t) teavm_local_2), ((int32_t) (teavm_local_2 >> INT32_C(32)))));
        teavm_gc_writeBarrier(teavm_this_);
        TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_digits) = teavm_local_3;
    }
    TEAVM_RELEASE_STACK;
}
void meth_jm_BigInteger__init__2(void* teavm_this_, int32_t teavm_local_1, TeaVM_Array* teavm_local_2) {
    int32_t teavm_local_3;
    TeaVM_Array* teavm_local_4;
    TEAVM_ALLOC_STACK(INT32_C(0));
    if ((!(((TeaVM_Class *) &jm_BigInteger_Cls)->flags & INT32_C(1)))) {
        TEAVM_WITH_CALL_SITE_ID(9651, initclass_jm_BigInteger());
    }
    TEAVM_WITH_CALL_SITE_ID(9652, meth_jl_Number__init_(teavm_this_));
    TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_firstNonzeroDigit) = -INT32_C(2);
    teavm_local_2 = TEAVM_WITH_CALL_SITE_ID(9653, teavm_nullCheck(teavm_local_2));
    teavm_local_3 = TEAVM_ARRAY_LENGTH(teavm_local_2);
    if (teavm_local_3) {
        TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_sign) = teavm_local_1;
        TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_numberLength) = teavm_local_3;
        teavm_gc_writeBarrier(teavm_this_);
        TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_digits) = teavm_local_2;
        TEAVM_WITH_CALL_SITE_ID(9654, meth_jm_BigInteger_cutOffLeadingZeroes(teavm_this_));
    } else {
        TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_sign) = INT32_C(0);
        TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_numberLength) = INT32_C(1);
        teavm_local_4 = TEAVM_WITH_CALL_SITE_ID(9655, meth_otr_Allocator_allocateArray(&Arr_I_Cls, INT32_C(1)));
        TEAVM_ARRAY_AT(teavm_local_4, int32_t, INT32_C(0)) = INT32_C(0);
        teavm_gc_writeBarrier(teavm_this_);
        TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_digits) = teavm_local_4;
    }
    TEAVM_RELEASE_STACK;
}
void* meth_jm_BigInteger_valueOf(int64_t teavm_local_1) {
    void* teavm_local_2;
    int64_t teavm_local_3;
    TeaVM_Array* teavm_local_4;
    int32_t teavm_local_5;
    TEAVM_ALLOC_STACK(INT32_C(1));
    if ((!(((TeaVM_Class *) &jm_BigInteger_Cls)->flags & INT32_C(1)))) {
        TEAVM_GC_ROOT_RELEASE(INT32_C(0));
        TEAVM_WITH_CALL_SITE_ID(9656, initclass_jm_BigInteger());
    }
    if ((teavm_local_1 < INT64_C(0))) {
        if ((teavm_local_1 == -INT64_C(1))) {
            teavm_local_2 = sfld_jm_BigInteger_MINUS_ONE;
        } else {
            TEAVM_GC_ROOT_RELEASE(INT32_C(0));
            teavm_local_2 = TEAVM_WITH_CALL_SITE_ID(9657, meth_otr_Allocator_allocate(&jm_BigInteger_Cls));
            teavm_local_3 = (-teavm_local_1);
            TEAVM_GC_ROOT(INT32_C(0), teavm_local_2);
            TEAVM_WITH_CALL_SITE_ID(9658, meth_jm_BigInteger__init__1(teavm_local_2, -INT32_C(1), teavm_local_3));
        }
    } else if ((teavm_local_1 > INT64_C(10))) {
        TEAVM_GC_ROOT_RELEASE(INT32_C(0));
        teavm_local_2 = TEAVM_WITH_CALL_SITE_ID(9659, meth_otr_Allocator_allocate(&jm_BigInteger_Cls));
        TEAVM_GC_ROOT(INT32_C(0), teavm_local_2);
        TEAVM_WITH_CALL_SITE_ID(9660, meth_jm_BigInteger__init__1(teavm_local_2, INT32_C(1), teavm_local_1));
    } else {
        teavm_local_4 = sfld_jm_BigInteger_SMALL_VALUES;
        teavm_local_5 = ((int32_t) teavm_local_1);
        TEAVM_GC_ROOT(INT32_C(0), teavm_local_4);
        teavm_local_4 = TEAVM_WITH_CALL_SITE_ID(9661, teavm_nullCheck(teavm_local_4));
        teavm_local_2 = TEAVM_ARRAY_AT(teavm_local_4, void*, TEAVM_WITH_CALL_SITE_ID(9662, teavm_checkBounds(teavm_local_5, teavm_local_4)));
    }
    TEAVM_RELEASE_STACK;
    return teavm_local_2;
}
void* meth_jm_BigInteger_abs(void* teavm_this_) {
    void* teavm_local_1;
    int32_t teavm_local_2;
    TeaVM_Array* teavm_local_3;
    TEAVM_ALLOC_STACK(INT32_C(2));
    if ((TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_sign) < INT32_C(0))) {
        TEAVM_GC_ROOT_RELEASE(INT32_C(0));
        TEAVM_GC_ROOT_RELEASE(INT32_C(1));
        teavm_local_1 = TEAVM_WITH_CALL_SITE_ID(9663, meth_otr_Allocator_allocate(&jm_BigInteger_Cls));
        teavm_local_2 = TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_numberLength);
        teavm_local_3 = TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_digits);
        TEAVM_GC_ROOT(INT32_C(0), teavm_local_1);
        TEAVM_GC_ROOT(INT32_C(1), teavm_local_3);
        TEAVM_WITH_CALL_SITE_ID(9664, meth_jm_BigInteger__init_(teavm_local_1, INT32_C(1), teavm_local_2, teavm_local_3));
        teavm_this_ = teavm_local_1;
    }
    TEAVM_RELEASE_STACK;
    return teavm_this_;
}
void* meth_jm_BigInteger_negate(void* teavm_this_) {
    void* teavm_local_1;
    int32_t teavm_local_2;
    int32_t teavm_local_3;
    TeaVM_Array* teavm_local_4;
    TEAVM_ALLOC_STACK(INT32_C(2));
    if ((!TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_sign))) {
        teavm_local_1 = teavm_this_;
    } else {
        TEAVM_GC_ROOT_RELEASE(INT32_C(0));
        TEAVM_GC_ROOT_RELEASE(INT32_C(1));
        teavm_local_1 = TEAVM_WITH_CALL_SITE_ID(9665, meth_otr_Allocator_allocate(&jm_BigInteger_Cls));
        teavm_local_2 = (-TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_sign));
        teavm_local_3 = TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_numberLength);
        teavm_local_4 = TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_digits);
        TEAVM_GC_ROOT(INT32_C(0), teavm_local_1);
        TEAVM_GC_ROOT(INT32_C(1), teavm_local_4);
        TEAVM_WITH_CALL_SITE_ID(9666, meth_jm_BigInteger__init_(teavm_local_1, teavm_local_2, teavm_local_3, teavm_local_4));
    }
    TEAVM_RELEASE_STACK;
    return teavm_local_1;
}
void* meth_jm_BigInteger_add(void* teavm_this_, void* teavm_local_1) {
    void* teavm_local_2;
    TEAVM_ALLOC_STACK(INT32_C(0));
    teavm_local_2 = TEAVM_WITH_CALL_SITE_ID(9667, meth_jm_Elementary_add(teavm_this_, teavm_local_1));
    TEAVM_RELEASE_STACK;
    return teavm_local_2;
}
void* meth_jm_BigInteger_subtract(void* teavm_this_, void* teavm_local_1) {
    void* teavm_local_2;
    TEAVM_ALLOC_STACK(INT32_C(0));
    teavm_local_2 = TEAVM_WITH_CALL_SITE_ID(9668, meth_jm_Elementary_subtract(teavm_this_, teavm_local_1));
    TEAVM_RELEASE_STACK;
    return teavm_local_2;
}
int32_t meth_jm_BigInteger_signum(void* teavm_this_) {
    return TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_sign);
}
void* meth_jm_BigInteger_shiftRight(void* teavm_this_, int32_t teavm_local_1) {
    TEAVM_ALLOC_STACK(INT32_C(0));
    if ((teavm_local_1 && TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_sign))) {
        teavm_this_ = ((teavm_local_1 > INT32_C(0)) ? TEAVM_WITH_CALL_SITE_ID(9669, meth_jm_BitLevel_shiftRight_0(teavm_this_, teavm_local_1)) : TEAVM_WITH_CALL_SITE_ID(9670, meth_jm_BitLevel_shiftLeft_0(teavm_this_, (-teavm_local_1))));
    }
    TEAVM_RELEASE_STACK;
    return teavm_this_;
}
void* meth_jm_BigInteger_shiftLeft(void* teavm_this_, int32_t teavm_local_1) {
    TEAVM_ALLOC_STACK(INT32_C(0));
    if ((teavm_local_1 && TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_sign))) {
        teavm_this_ = ((teavm_local_1 > INT32_C(0)) ? TEAVM_WITH_CALL_SITE_ID(9671, meth_jm_BitLevel_shiftLeft_0(teavm_this_, teavm_local_1)) : TEAVM_WITH_CALL_SITE_ID(9672, meth_jm_BitLevel_shiftRight_0(teavm_this_, (-teavm_local_1))));
    }
    TEAVM_RELEASE_STACK;
    return teavm_this_;
}
int32_t meth_jm_BigInteger_bitLength(void* teavm_this_) {
    int32_t teavm_local_1;
    TEAVM_ALLOC_STACK(INT32_C(0));
    teavm_local_1 = TEAVM_WITH_CALL_SITE_ID(9673, meth_jm_BitLevel_bitLength(teavm_this_));
    TEAVM_RELEASE_STACK;
    return teavm_local_1;
}
int32_t meth_jm_BigInteger_testBit(void* teavm_this_, int32_t teavm_local_1) {
    TeaVM_Array* teavm_local_2;
    int32_t teavm_local_3;
    void* teavm_local_4;
    int32_t teavm_local_5;
    int32_t teavm_local_6;
    int32_t teavm_local_7;
    TEAVM_ALLOC_STACK(INT32_C(1));
    if ((!teavm_local_1)) {
        teavm_local_2 = TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_digits);
        TEAVM_GC_ROOT(INT32_C(0), teavm_local_2);
        teavm_local_2 = TEAVM_WITH_CALL_SITE_ID(9674, teavm_nullCheck(teavm_local_2));
        teavm_local_3 = ((!(TEAVM_ARRAY_AT(teavm_local_2, int32_t, TEAVM_WITH_CALL_SITE_ID(9675, teavm_checkUpperBound(INT32_C(0), teavm_local_2))) & INT32_C(1))) ? INT32_C(0) : INT32_C(1));
    } else {
        if ((teavm_local_1 < INT32_C(0))) {
            TEAVM_GC_ROOT_RELEASE(INT32_C(0));
            teavm_local_4 = TEAVM_WITH_CALL_SITE_ID(9676, meth_otr_Allocator_allocate(&jl_ArithmeticException_Cls));
            TEAVM_GC_ROOT(INT32_C(0), teavm_local_4);
            TEAVM_WITH_CALL_SITE_ID(9677, meth_jl_ArithmeticException__init_(teavm_local_4, TEAVM_GET_STRING(570)));
            TEAVM_WITH_CALL_SITE_ID(9678, meth_otr_ExceptionHandling_throwException(teavm_local_4));
            TEAVM_UNREACHABLE
        }
        teavm_local_5 = (teavm_local_1 >> INT32_C(5));
        if ((teavm_local_5 >= TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_numberLength))) {
            teavm_local_3 = ((TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_sign) >= INT32_C(0)) ? INT32_C(0) : INT32_C(1));
        } else {
            teavm_local_2 = TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_digits);
            TEAVM_GC_ROOT(INT32_C(0), teavm_local_2);
            teavm_local_2 = TEAVM_WITH_CALL_SITE_ID(9679, teavm_nullCheck(teavm_local_2));
            teavm_local_5 = TEAVM_WITH_CALL_SITE_ID(9680, teavm_checkBounds(teavm_local_5, teavm_local_2));
            teavm_local_6 = TEAVM_ARRAY_AT(teavm_local_2, int32_t, teavm_local_5);
            teavm_local_3 = (INT32_C(1) << (teavm_local_1 & INT32_C(31)));
            if ((TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_sign) < INT32_C(0))) {
                TEAVM_GC_ROOT_RELEASE(INT32_C(0));
                teavm_local_7 = TEAVM_WITH_CALL_SITE_ID(9681, TEAVM_METHOD(teavm_this_, jm_BigInteger_VT, virt_getFirstNonzeroDigit)(teavm_this_));
                if ((teavm_local_5 < teavm_local_7)) {
                    teavm_local_3 = INT32_C(0);
                    goto teavm_label_1;
                }
                teavm_local_6 = ((teavm_local_7 == teavm_local_5) ? (-teavm_local_6) : (teavm_local_6 ^ -INT32_C(1)));
            }
            teavm_local_3 = ((!(teavm_local_6 & teavm_local_3)) ? INT32_C(0) : INT32_C(1));
        }
    }
teavm_label_1:;
    TEAVM_RELEASE_STACK;
    return teavm_local_3;
}
int32_t meth_jm_BigInteger_intValue(void* teavm_this_) {
    int32_t teavm_local_1;
    TeaVM_Array* teavm_local_2;
    TEAVM_ALLOC_STACK(INT32_C(1));
    teavm_local_1 = TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_sign);
    teavm_local_2 = TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_digits);
    TEAVM_GC_ROOT(INT32_C(0), teavm_local_2);
    teavm_local_2 = TEAVM_WITH_CALL_SITE_ID(9682, teavm_nullCheck(teavm_local_2));
    teavm_local_1 = (teavm_local_1 * TEAVM_ARRAY_AT(teavm_local_2, int32_t, TEAVM_WITH_CALL_SITE_ID(9683, teavm_checkUpperBound(INT32_C(0), teavm_local_2))));
    TEAVM_RELEASE_STACK;
    return teavm_local_1;
}
int64_t meth_jm_BigInteger_longValue(void* teavm_this_) {
    TeaVM_Array* teavm_local_1;
    int64_t teavm_local_2;
    int64_t teavm_local_3;
    int64_t teavm_local_4;
    TEAVM_ALLOC_STACK(INT32_C(1));
    if ((TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_numberLength) <= INT32_C(1))) {
        teavm_local_1 = TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_digits);
        TEAVM_GC_ROOT(INT32_C(0), teavm_local_1);
        teavm_local_1 = TEAVM_WITH_CALL_SITE_ID(9684, teavm_nullCheck(teavm_local_1));
        teavm_local_2 = (((int64_t) TEAVM_ARRAY_AT(teavm_local_1, int32_t, TEAVM_WITH_CALL_SITE_ID(9685, teavm_checkUpperBound(INT32_C(0), teavm_local_1)))) & INT64_C(4294967295));
    } else {
        teavm_local_1 = TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_digits);
        TEAVM_GC_ROOT(INT32_C(0), teavm_local_1);
        teavm_local_1 = TEAVM_WITH_CALL_SITE_ID(9686, teavm_nullCheck(teavm_local_1));
        teavm_local_3 = (((int64_t) TEAVM_ARRAY_AT(teavm_local_1, int32_t, TEAVM_WITH_CALL_SITE_ID(9687, teavm_checkUpperBound(INT32_C(1), teavm_local_1)))) << INT32_C(32));
        teavm_local_1 = TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_digits);
        TEAVM_GC_ROOT(INT32_C(0), teavm_local_1);
        teavm_local_1 = TEAVM_WITH_CALL_SITE_ID(9688, teavm_nullCheck(teavm_local_1));
        teavm_local_2 = (teavm_local_3 | (((int64_t) TEAVM_ARRAY_AT(teavm_local_1, int32_t, TEAVM_WITH_CALL_SITE_ID(9689, teavm_checkUpperBound(INT32_C(0), teavm_local_1)))) & INT64_C(4294967295)));
    }
    teavm_local_4 = (((int64_t) TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_sign)) * teavm_local_2);
    TEAVM_RELEASE_STACK;
    return teavm_local_4;
}
double meth_jm_BigInteger_doubleValue(void* teavm_this_) {
    double teavm_local_1;
    TEAVM_ALLOC_STACK(INT32_C(0));
    teavm_local_1 = TEAVM_WITH_CALL_SITE_ID(9690, meth_jm_Conversion_bigInteger2Double(teavm_this_));
    TEAVM_RELEASE_STACK;
    return teavm_local_1;
}
int32_t meth_jm_BigInteger_compareTo(void* teavm_this_, void* teavm_local_1) {
    int32_t teavm_local_2;
    TeaVM_Array* teavm_local_3;
    TeaVM_Array* teavm_local_4;
    int32_t teavm_local_5;
    TEAVM_ALLOC_STACK(INT32_C(2));
    teavm_local_2 = TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_sign);
    TEAVM_GC_ROOT_RELEASE(INT32_C(0));
    TEAVM_GC_ROOT_RELEASE(INT32_C(1));
    teavm_local_1 = TEAVM_WITH_CALL_SITE_ID(9691, teavm_nullCheck(teavm_local_1));
    if ((teavm_local_2 > TEAVM_FIELD(teavm_local_1, cls_jm_BigInteger, fld_sign))) {
        teavm_local_2 = INT32_C(1);
    } else if ((TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_sign) < TEAVM_FIELD(teavm_local_1, cls_jm_BigInteger, fld_sign))) {
        teavm_local_2 = -INT32_C(1);
    } else if ((TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_numberLength) > TEAVM_FIELD(teavm_local_1, cls_jm_BigInteger, fld_numberLength))) {
        teavm_local_2 = TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_sign);
    } else if ((TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_numberLength) < TEAVM_FIELD(teavm_local_1, cls_jm_BigInteger, fld_numberLength))) {
        teavm_local_2 = (-TEAVM_FIELD(teavm_local_1, cls_jm_BigInteger, fld_sign));
    } else {
        teavm_local_2 = TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_sign);
        teavm_local_3 = TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_digits);
        teavm_local_4 = TEAVM_FIELD(teavm_local_1, cls_jm_BigInteger, fld_digits);
        teavm_local_5 = TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_numberLength);
        TEAVM_GC_ROOT(INT32_C(0), teavm_local_3);
        TEAVM_GC_ROOT(INT32_C(1), teavm_local_4);
        teavm_local_2 = (teavm_local_2 * TEAVM_WITH_CALL_SITE_ID(9692, meth_jm_Elementary_compareArrays(teavm_local_3, teavm_local_4, teavm_local_5)));
    }
    TEAVM_RELEASE_STACK;
    return teavm_local_2;
}
int32_t meth_jm_BigInteger_equals(void* teavm_this_, void* teavm_local_1) {
    int32_t teavm_local_2;
    void* teavm_local_3;
    TeaVM_Array* teavm_local_4;
    TEAVM_ALLOC_STACK(INT32_C(1));
    if ((teavm_this_ == teavm_local_1)) {
        teavm_local_2 = INT32_C(1);
    } else if ((!teavm_instanceof(teavm_local_1, supertypeof_jm_BigInteger))) {
        teavm_local_2 = INT32_C(0);
    } else {
        TEAVM_GC_ROOT_RELEASE(INT32_C(0));
        teavm_local_3 = TEAVM_WITH_CALL_SITE_ID(9693, teavm_checkcast(teavm_local_1, supertypeof_jm_BigInteger));
        teavm_local_2 = TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_sign);
        TEAVM_GC_ROOT(INT32_C(0), teavm_local_3);
        teavm_local_3 = TEAVM_WITH_CALL_SITE_ID(9694, teavm_nullCheck(teavm_local_3));
        if (((teavm_local_2 == TEAVM_FIELD(teavm_local_3, cls_jm_BigInteger, fld_sign)) && (TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_numberLength) == TEAVM_FIELD(teavm_local_3, cls_jm_BigInteger, fld_numberLength)))) {
            teavm_local_4 = TEAVM_FIELD(teavm_local_3, cls_jm_BigInteger, fld_digits);
            TEAVM_GC_ROOT(INT32_C(0), teavm_local_4);
            if (TEAVM_WITH_CALL_SITE_ID(9695, TEAVM_METHOD(teavm_this_, jm_BigInteger_VT, virt_equalsArrays)(teavm_this_, teavm_local_4))) {
                teavm_local_2 = INT32_C(1);
                goto teavm_label_1;
            }
        }
        teavm_local_2 = INT32_C(0);
    teavm_label_1:;
    }
    TEAVM_RELEASE_STACK;
    return teavm_local_2;
}
int32_t meth_jm_BigInteger_equalsArrays(void* teavm_this_, TeaVM_Array* teavm_local_1) {
    int32_t teavm_local_2;
    TeaVM_Array* teavm_local_3;
    int32_t teavm_local_4;
    TEAVM_ALLOC_STACK(INT32_C(2));
    teavm_local_2 = (TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_numberLength) - INT32_C(1));
    while (1) {
        if (!(teavm_local_2 >= INT32_C(0))) break;
        teavm_local_3 = TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_digits);
        TEAVM_GC_ROOT(INT32_C(0), teavm_local_3);
        TEAVM_GC_ROOT(INT32_C(1), teavm_local_1);
        teavm_local_3 = TEAVM_WITH_CALL_SITE_ID(9696, teavm_nullCheck(teavm_local_3));
        teavm_local_2 = TEAVM_WITH_CALL_SITE_ID(9697, teavm_checkBounds(teavm_local_2, teavm_local_3));
        teavm_local_4 = TEAVM_ARRAY_AT(teavm_local_3, int32_t, teavm_local_2);
        TEAVM_GC_ROOT_RELEASE(INT32_C(0));
        teavm_local_1 = TEAVM_WITH_CALL_SITE_ID(9698, teavm_nullCheck(teavm_local_1));
        teavm_local_3 = teavm_local_1;
        teavm_local_2 = TEAVM_WITH_CALL_SITE_ID(9699, teavm_checkUpperBound(teavm_local_2, teavm_local_3));
        if ((teavm_local_4 != TEAVM_ARRAY_AT(teavm_local_3, int32_t, teavm_local_2))) {
            goto teavm_label_1;
        }
        teavm_local_2 = (teavm_local_2 + -INT32_C(1));
    }
teavm_label_1:;
    teavm_local_4 = ((teavm_local_2 >= INT32_C(0)) ? INT32_C(0) : INT32_C(1));
    TEAVM_RELEASE_STACK;
    return teavm_local_4;
}
void* meth_jm_BigInteger_multiply(void* teavm_this_, void* teavm_local_1) {
    void* teavm_local_2;
    TEAVM_ALLOC_STACK(INT32_C(1));
    TEAVM_GC_ROOT_RELEASE(INT32_C(0));
    teavm_local_1 = TEAVM_WITH_CALL_SITE_ID(9700, teavm_nullCheck(teavm_local_1));
    if ((!TEAVM_FIELD(teavm_local_1, cls_jm_BigInteger, fld_sign))) {
        if ((!(((TeaVM_Class *) &jm_BigInteger_Cls)->flags & INT32_C(1)))) {
            TEAVM_WITH_CALL_SITE_ID(9701, initclass_jm_BigInteger());
        }
        teavm_local_2 = sfld_jm_BigInteger_ZERO;
    } else if (TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_sign)) {
        TEAVM_GC_ROOT(INT32_C(0), teavm_local_1);
        teavm_local_2 = TEAVM_WITH_CALL_SITE_ID(9702, meth_jm_Multiplication_multiply(teavm_this_, teavm_local_1));
    } else {
        if ((!(((TeaVM_Class *) &jm_BigInteger_Cls)->flags & INT32_C(1)))) {
            TEAVM_WITH_CALL_SITE_ID(9703, initclass_jm_BigInteger());
        }
        teavm_local_2 = sfld_jm_BigInteger_ZERO;
    }
    TEAVM_RELEASE_STACK;
    return teavm_local_2;
}
void* meth_jm_BigInteger_pow(void* teavm_this_, int32_t teavm_local_1) {
    void* teavm_local_2;
    int32_t teavm_local_3;
    void* teavm_local_4;
    void* teavm_tmp_ptr_0;
    TEAVM_ALLOC_STACK(INT32_C(2));
    if ((teavm_local_1 < INT32_C(0))) {
        TEAVM_GC_ROOT_RELEASE(INT32_C(0));
        TEAVM_GC_ROOT_RELEASE(INT32_C(1));
        teavm_local_2 = TEAVM_WITH_CALL_SITE_ID(9704, meth_otr_Allocator_allocate(&jl_ArithmeticException_Cls));
        TEAVM_GC_ROOT(INT32_C(0), teavm_local_2);
        TEAVM_WITH_CALL_SITE_ID(9705, meth_jl_ArithmeticException__init_(teavm_local_2, TEAVM_GET_STRING(571)));
        TEAVM_WITH_CALL_SITE_ID(9706, meth_otr_ExceptionHandling_throwException(teavm_local_2));
        TEAVM_UNREACHABLE
    }
    if ((!teavm_local_1)) {
        if ((!(((TeaVM_Class *) &jm_BigInteger_Cls)->flags & INT32_C(1)))) {
            TEAVM_GC_ROOT_RELEASE(INT32_C(0));
            TEAVM_GC_ROOT_RELEASE(INT32_C(1));
            TEAVM_WITH_CALL_SITE_ID(9707, initclass_jm_BigInteger());
        }
        teavm_this_ = sfld_jm_BigInteger_ONE;
    } else if ((teavm_local_1 != INT32_C(1))) {
        if ((!(((TeaVM_Class *) &jm_BigInteger_Cls)->flags & INT32_C(1)))) {
            TEAVM_GC_ROOT_RELEASE(INT32_C(0));
            TEAVM_GC_ROOT_RELEASE(INT32_C(1));
            TEAVM_WITH_CALL_SITE_ID(9708, initclass_jm_BigInteger());
        }
        teavm_local_2 = sfld_jm_BigInteger_ONE;
        TEAVM_GC_ROOT(INT32_C(0), teavm_local_2);
        TEAVM_GC_ROOT_RELEASE(INT32_C(1));
        if ((!TEAVM_WITH_CALL_SITE_ID(9709, TEAVM_METHOD(teavm_this_, jm_BigInteger_VT, virt_equals)(teavm_this_, teavm_local_2)))) {
            teavm_local_2 = sfld_jm_BigInteger_ZERO;
            TEAVM_GC_ROOT(INT32_C(0), teavm_local_2);
            if ((!TEAVM_WITH_CALL_SITE_ID(9710, TEAVM_METHOD(teavm_this_, jm_BigInteger_VT, virt_equals)(teavm_this_, teavm_local_2)))) {
                TEAVM_GC_ROOT_RELEASE(INT32_C(0));
                if (TEAVM_WITH_CALL_SITE_ID(9711, TEAVM_METHOD(teavm_this_, jm_BigInteger_VT, virt_testBit)(teavm_this_, INT32_C(0)))) {
                    teavm_this_ = TEAVM_WITH_CALL_SITE_ID(9712, meth_jm_Multiplication_pow(teavm_this_, teavm_local_1));
                } else {
                    teavm_local_3 = INT32_C(1);
                    while (1) {
                        if (!(!TEAVM_WITH_CALL_SITE_ID(9713, TEAVM_METHOD(teavm_this_, jm_BigInteger_VT, virt_testBit)(teavm_this_, teavm_local_3)))) break;
                        teavm_local_3 = (teavm_local_3 + INT32_C(1));
                    }
                    teavm_local_2 = TEAVM_WITH_CALL_SITE_ID(9714, meth_jm_BigInteger_getPowerOfTwo((teavm_local_3 * teavm_local_1)));
                    TEAVM_GC_ROOT(INT32_C(0), teavm_local_2);
                    teavm_local_4 = TEAVM_WITH_CALL_SITE_ID(9715, TEAVM_METHOD(teavm_this_, jm_BigInteger_VT, virt_shiftRight)(teavm_this_, teavm_local_3));
                    TEAVM_GC_ROOT(INT32_C(1), teavm_local_4);
                    teavm_local_4 = TEAVM_WITH_CALL_SITE_ID(9716, ((teavm_tmp_ptr_0 = TEAVM_WITH_CALL_SITE_ID(9717, teavm_nullCheck(teavm_local_4))), TEAVM_METHOD(teavm_tmp_ptr_0, jm_BigInteger_VT, virt_pow)(teavm_tmp_ptr_0, teavm_local_1)));
                    TEAVM_GC_ROOT(INT32_C(1), teavm_local_4);
                    teavm_this_ = TEAVM_WITH_CALL_SITE_ID(9718, ((teavm_tmp_ptr_0 = TEAVM_WITH_CALL_SITE_ID(9719, teavm_nullCheck(teavm_local_2))), TEAVM_METHOD(teavm_tmp_ptr_0, jm_BigInteger_VT, virt_multiply)(teavm_tmp_ptr_0, teavm_local_4)));
                }
            }
        }
    }
    TEAVM_RELEASE_STACK;
    return teavm_this_;
}
TeaVM_Array* meth_jm_BigInteger_divideAndRemainder(void* teavm_this_, void* teavm_local_1) {
    int32_t teavm_local_2;
    void* teavm_local_3;
    int32_t teavm_local_4;
    TeaVM_Array* teavm_local_5;
    TeaVM_Array* teavm_local_6;
    int32_t teavm_local_7;
    TeaVM_Array* teavm_local_8;
    int32_t teavm_local_9;
    int32_t teavm_local_10;
    TeaVM_Array* teavm_local_11;
    int32_t teavm_local_12;
    int32_t teavm_local_13;
    int32_t teavm_local_14;
    TeaVM_Array* teavm_local_15;
    TeaVM_Array* teavm_local_16;
    void* teavm_local_17;
    void* teavm_local_18;
    TEAVM_ALLOC_STACK(INT32_C(3));
    TEAVM_GC_ROOT_RELEASE(INT32_C(0));
    TEAVM_GC_ROOT_RELEASE(INT32_C(1));
    TEAVM_GC_ROOT_RELEASE(INT32_C(2));
    teavm_local_1 = TEAVM_WITH_CALL_SITE_ID(9720, teavm_nullCheck(teavm_local_1));
    teavm_local_2 = TEAVM_FIELD(teavm_local_1, cls_jm_BigInteger, fld_sign);
    if ((!teavm_local_2)) {
        teavm_local_3 = TEAVM_WITH_CALL_SITE_ID(9721, meth_otr_Allocator_allocate(&jl_ArithmeticException_Cls));
        TEAVM_GC_ROOT(INT32_C(0), teavm_local_3);
        TEAVM_WITH_CALL_SITE_ID(9722, meth_jl_ArithmeticException__init_(teavm_local_3, TEAVM_GET_STRING(572)));
        TEAVM_WITH_CALL_SITE_ID(9723, meth_otr_ExceptionHandling_throwException(teavm_local_3));
        TEAVM_UNREACHABLE
    }
    teavm_local_4 = TEAVM_FIELD(teavm_local_1, cls_jm_BigInteger, fld_numberLength);
    teavm_local_5 = TEAVM_FIELD(teavm_local_1, cls_jm_BigInteger, fld_digits);
    if ((teavm_local_4 == INT32_C(1))) {
        TEAVM_GC_ROOT(INT32_C(0), teavm_local_5);
        teavm_local_5 = TEAVM_WITH_CALL_SITE_ID(9724, teavm_nullCheck(teavm_local_5));
        teavm_local_6 = teavm_local_5;
        teavm_local_7 = TEAVM_ARRAY_AT(teavm_local_6, int32_t, TEAVM_WITH_CALL_SITE_ID(9725, teavm_checkUpperBound(INT32_C(0), teavm_local_6)));
        TEAVM_GC_ROOT_RELEASE(INT32_C(0));
        teavm_local_6 = TEAVM_WITH_CALL_SITE_ID(9726, meth_jm_Division_divideAndRemainderByInteger(teavm_this_, teavm_local_7, teavm_local_2));
    } else {
        teavm_local_8 = TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_digits);
        teavm_local_9 = TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_numberLength);
        teavm_local_7 = teavm_compare_i32(teavm_local_9, teavm_local_4);
        if ((!teavm_local_7)) {
            TEAVM_GC_ROOT(INT32_C(0), teavm_local_5);
            TEAVM_GC_ROOT(INT32_C(1), teavm_local_8);
            teavm_local_10 = TEAVM_WITH_CALL_SITE_ID(9727, meth_jm_Elementary_compareArrays(teavm_local_8, teavm_local_5, teavm_local_9));
        } else {
            teavm_local_10 = ((teavm_local_7 <= INT32_C(0)) ? -INT32_C(1) : INT32_C(1));
        }
        if ((teavm_local_10 < INT32_C(0))) {
            teavm_local_6 = TEAVM_WITH_CALL_SITE_ID(9728, meth_otr_Allocator_allocateArray(&Arr_jm_BigInteger_Cls, INT32_C(2)));
            teavm_local_11 = teavm_local_6;
            if ((!(((TeaVM_Class *) &jm_BigInteger_Cls)->flags & INT32_C(1)))) {
                TEAVM_GC_ROOT(INT32_C(0), teavm_local_11);
                TEAVM_WITH_CALL_SITE_ID(9729, initclass_jm_BigInteger());
            }
            teavm_local_3 = sfld_jm_BigInteger_ZERO;
            teavm_gc_writeBarrier(teavm_local_11);
            TEAVM_ARRAY_AT(teavm_local_11, void*, INT32_C(0)) = teavm_local_3;
            TEAVM_ARRAY_AT(teavm_local_11, void*, INT32_C(1)) = teavm_this_;
        } else {
            teavm_local_12 = TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_sign);
            teavm_local_13 = ((teavm_local_9 - teavm_local_4) + INT32_C(1));
            teavm_local_14 = ((teavm_local_12 != teavm_local_2) ? -INT32_C(1) : INT32_C(1));
            TEAVM_GC_ROOT(INT32_C(0), teavm_local_5);
            TEAVM_GC_ROOT(INT32_C(1), teavm_local_8);
            teavm_local_15 = TEAVM_WITH_CALL_SITE_ID(9730, meth_otr_Allocator_allocateArray(&Arr_I_Cls, teavm_local_13));
            TEAVM_GC_ROOT(INT32_C(2), teavm_local_15);
            teavm_local_16 = TEAVM_WITH_CALL_SITE_ID(9731, meth_jm_Division_divide(teavm_local_15, teavm_local_13, teavm_local_8, teavm_local_9, teavm_local_5, teavm_local_4));
            TEAVM_GC_ROOT(INT32_C(0), teavm_local_16);
            TEAVM_GC_ROOT_RELEASE(INT32_C(1));
            teavm_local_17 = TEAVM_WITH_CALL_SITE_ID(9732, meth_otr_Allocator_allocate(&jm_BigInteger_Cls));
            TEAVM_GC_ROOT(INT32_C(1), teavm_local_17);
            TEAVM_WITH_CALL_SITE_ID(9733, meth_jm_BigInteger__init_(teavm_local_17, teavm_local_14, teavm_local_13, teavm_local_15));
            TEAVM_GC_ROOT_RELEASE(INT32_C(2));
            teavm_local_18 = TEAVM_WITH_CALL_SITE_ID(9734, meth_otr_Allocator_allocate(&jm_BigInteger_Cls));
            TEAVM_GC_ROOT(INT32_C(2), teavm_local_18);
            TEAVM_WITH_CALL_SITE_ID(9735, meth_jm_BigInteger__init_(teavm_local_18, teavm_local_12, teavm_local_4, teavm_local_16));
            TEAVM_GC_ROOT_RELEASE(INT32_C(0));
            TEAVM_WITH_CALL_SITE_ID(9736, meth_jm_BigInteger_cutOffLeadingZeroes(teavm_local_17));
            TEAVM_WITH_CALL_SITE_ID(9737, meth_jm_BigInteger_cutOffLeadingZeroes(teavm_local_18));
            teavm_local_6 = TEAVM_WITH_CALL_SITE_ID(9738, meth_otr_Allocator_allocateArray(&Arr_jm_BigInteger_Cls, INT32_C(2)));
            teavm_local_11 = teavm_local_6;
            teavm_gc_writeBarrier(teavm_local_11);
            TEAVM_ARRAY_AT(teavm_local_11, void*, INT32_C(0)) = teavm_local_17;
            TEAVM_ARRAY_AT(teavm_local_11, void*, INT32_C(1)) = teavm_local_18;
        }
    }
    TEAVM_RELEASE_STACK;
    return teavm_local_6;
}
void* meth_jm_BigInteger_divide(void* teavm_this_, void* teavm_local_1) {
    void* teavm_local_2;
    int32_t teavm_local_3;
    int32_t teavm_local_4;
    int32_t teavm_local_5;
    int32_t teavm_local_6;
    TeaVM_Array* teavm_local_7;
    int64_t teavm_local_8;
    int64_t teavm_local_9;
    int32_t teavm_local_10;
    TeaVM_Array* teavm_local_11;
    int32_t teavm_local_12;
    int32_t teavm_local_13;
    TeaVM_Array* teavm_local_14;
    int32_t teavm_local_15;
    TEAVM_ALLOC_STACK(INT32_C(3));
    TEAVM_GC_ROOT_RELEASE(INT32_C(0));
    TEAVM_GC_ROOT_RELEASE(INT32_C(1));
    TEAVM_GC_ROOT_RELEASE(INT32_C(2));
    teavm_local_1 = TEAVM_WITH_CALL_SITE_ID(9739, teavm_nullCheck(teavm_local_1));
    if ((!TEAVM_FIELD(teavm_local_1, cls_jm_BigInteger, fld_sign))) {
        teavm_local_2 = TEAVM_WITH_CALL_SITE_ID(9740, meth_otr_Allocator_allocate(&jl_ArithmeticException_Cls));
        TEAVM_GC_ROOT(INT32_C(0), teavm_local_2);
        TEAVM_WITH_CALL_SITE_ID(9741, meth_jl_ArithmeticException__init_(teavm_local_2, TEAVM_GET_STRING(572)));
        TEAVM_WITH_CALL_SITE_ID(9742, meth_otr_ExceptionHandling_throwException(teavm_local_2));
        TEAVM_UNREACHABLE
    }
    teavm_local_3 = TEAVM_FIELD(teavm_local_1, cls_jm_BigInteger, fld_sign);
    TEAVM_GC_ROOT(INT32_C(0), teavm_local_1);
    if ((!TEAVM_WITH_CALL_SITE_ID(9743, TEAVM_METHOD(teavm_local_1, jm_BigInteger_VT, virt_isOne)(teavm_local_1)))) {
        teavm_local_4 = TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_sign);
        teavm_local_5 = TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_numberLength);
        teavm_local_6 = TEAVM_FIELD(teavm_local_1, cls_jm_BigInteger, fld_numberLength);
        if (((teavm_local_5 + teavm_local_6) == INT32_C(2))) {
            teavm_local_7 = TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_digits);
            TEAVM_GC_ROOT(INT32_C(1), teavm_local_7);
            teavm_local_7 = TEAVM_WITH_CALL_SITE_ID(9744, teavm_nullCheck(teavm_local_7));
            teavm_local_8 = (((int64_t) TEAVM_ARRAY_AT(teavm_local_7, int32_t, TEAVM_WITH_CALL_SITE_ID(9745, teavm_checkUpperBound(INT32_C(0), teavm_local_7)))) & INT64_C(4294967295));
            teavm_local_7 = TEAVM_FIELD(teavm_local_1, cls_jm_BigInteger, fld_digits);
            TEAVM_GC_ROOT(INT32_C(0), teavm_local_7);
            TEAVM_GC_ROOT_RELEASE(INT32_C(1));
            teavm_local_7 = TEAVM_WITH_CALL_SITE_ID(9746, teavm_nullCheck(teavm_local_7));
            teavm_local_9 = (teavm_local_8 / (((int64_t) TEAVM_ARRAY_AT(teavm_local_7, int32_t, TEAVM_WITH_CALL_SITE_ID(9747, teavm_checkUpperBound(INT32_C(0), teavm_local_7)))) & INT64_C(4294967295)));
            if ((teavm_local_4 != teavm_local_3)) {
                teavm_local_9 = (-teavm_local_9);
            }
            TEAVM_GC_ROOT_RELEASE(INT32_C(0));
            teavm_this_ = TEAVM_WITH_CALL_SITE_ID(9748, meth_jm_BigInteger_valueOf(teavm_local_9));
        } else {
            teavm_local_10 = teavm_compare_i32(teavm_local_5, teavm_local_6);
            if ((!teavm_local_10)) {
                teavm_local_7 = TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_digits);
                teavm_local_11 = TEAVM_FIELD(teavm_local_1, cls_jm_BigInteger, fld_digits);
                TEAVM_GC_ROOT(INT32_C(1), teavm_local_7);
                TEAVM_GC_ROOT(INT32_C(2), teavm_local_11);
                teavm_local_12 = TEAVM_WITH_CALL_SITE_ID(9749, meth_jm_Elementary_compareArrays(teavm_local_7, teavm_local_11, teavm_local_5));
            } else {
                teavm_local_12 = ((teavm_local_10 <= INT32_C(0)) ? -INT32_C(1) : INT32_C(1));
            }
            if ((!teavm_local_12)) {
                teavm_this_ = ((teavm_local_4 != teavm_local_3) ? sfld_jm_BigInteger_MINUS_ONE : sfld_jm_BigInteger_ONE);
            } else if ((teavm_local_12 == -INT32_C(1))) {
                teavm_this_ = sfld_jm_BigInteger_ZERO;
            } else {
                teavm_local_13 = ((teavm_local_5 - teavm_local_6) + INT32_C(1));
                teavm_local_14 = TEAVM_WITH_CALL_SITE_ID(9750, meth_otr_Allocator_allocateArray(&Arr_I_Cls, teavm_local_13));
                teavm_local_15 = ((teavm_local_4 != teavm_local_3) ? -INT32_C(1) : INT32_C(1));
                if ((teavm_local_6 != INT32_C(1))) {
                    teavm_local_7 = TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_digits);
                    teavm_local_11 = TEAVM_FIELD(teavm_local_1, cls_jm_BigInteger, fld_digits);
                    TEAVM_GC_ROOT(INT32_C(0), teavm_local_14);
                    TEAVM_GC_ROOT(INT32_C(1), teavm_local_7);
                    TEAVM_GC_ROOT(INT32_C(2), teavm_local_11);
                    TEAVM_WITH_CALL_SITE_ID(9751, meth_jm_Division_divide(teavm_local_14, teavm_local_13, teavm_local_7, teavm_local_5, teavm_local_11, teavm_local_6));
                } else {
                    teavm_local_7 = TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_digits);
                    teavm_local_11 = TEAVM_FIELD(teavm_local_1, cls_jm_BigInteger, fld_digits);
                    TEAVM_GC_ROOT(INT32_C(0), teavm_local_14);
                    TEAVM_GC_ROOT(INT32_C(1), teavm_local_7);
                    TEAVM_GC_ROOT(INT32_C(2), teavm_local_11);
                    teavm_local_11 = TEAVM_WITH_CALL_SITE_ID(9752, teavm_nullCheck(teavm_local_11));
                    teavm_local_10 = TEAVM_ARRAY_AT(teavm_local_11, int32_t, TEAVM_WITH_CALL_SITE_ID(9753, teavm_checkUpperBound(INT32_C(0), teavm_local_11)));
                    TEAVM_GC_ROOT_RELEASE(INT32_C(2));
                    TEAVM_WITH_CALL_SITE_ID(9754, meth_jm_Division_divideArrayByInt(teavm_local_14, teavm_local_7, teavm_local_5, teavm_local_10));
                }
                TEAVM_GC_ROOT(INT32_C(0), teavm_local_14);
                teavm_this_ = TEAVM_WITH_CALL_SITE_ID(9755, meth_otr_Allocator_allocate(&jm_BigInteger_Cls));
                TEAVM_GC_ROOT(INT32_C(1), teavm_this_);
                TEAVM_WITH_CALL_SITE_ID(9756, meth_jm_BigInteger__init_(teavm_this_, teavm_local_15, teavm_local_13, teavm_local_14));
                TEAVM_GC_ROOT_RELEASE(INT32_C(0));
                TEAVM_WITH_CALL_SITE_ID(9757, meth_jm_BigInteger_cutOffLeadingZeroes(teavm_this_));
            }
        }
    } else if ((TEAVM_FIELD(teavm_local_1, cls_jm_BigInteger, fld_sign) <= INT32_C(0))) {
        TEAVM_GC_ROOT_RELEASE(INT32_C(0));
        teavm_this_ = TEAVM_WITH_CALL_SITE_ID(9758, TEAVM_METHOD(teavm_this_, jm_BigInteger_VT, virt_negate)(teavm_this_));
    }
    TEAVM_RELEASE_STACK;
    return teavm_this_;
}
void* meth_jm_BigInteger_remainder(void* teavm_this_, void* teavm_local_1) {
    void* teavm_local_2;
    int32_t teavm_local_3;
    int32_t teavm_local_4;
    int32_t teavm_local_5;
    TeaVM_Array* teavm_local_6;
    TeaVM_Array* teavm_local_7;
    TeaVM_Array* teavm_local_8;
    int32_t teavm_local_9;
    TeaVM_Array* teavm_local_10;
    int32_t teavm_local_11;
    void* teavm_local_12;
    int32_t teavm_local_13;
    TEAVM_ALLOC_STACK(INT32_C(3));
    TEAVM_GC_ROOT_RELEASE(INT32_C(0));
    TEAVM_GC_ROOT_RELEASE(INT32_C(1));
    TEAVM_GC_ROOT_RELEASE(INT32_C(2));
    teavm_local_1 = TEAVM_WITH_CALL_SITE_ID(9759, teavm_nullCheck(teavm_local_1));
    if ((!TEAVM_FIELD(teavm_local_1, cls_jm_BigInteger, fld_sign))) {
        teavm_local_2 = TEAVM_WITH_CALL_SITE_ID(9760, meth_otr_Allocator_allocate(&jl_ArithmeticException_Cls));
        TEAVM_GC_ROOT(INT32_C(0), teavm_local_2);
        TEAVM_WITH_CALL_SITE_ID(9761, meth_jl_ArithmeticException__init_(teavm_local_2, TEAVM_GET_STRING(572)));
        TEAVM_WITH_CALL_SITE_ID(9762, meth_otr_ExceptionHandling_throwException(teavm_local_2));
        TEAVM_UNREACHABLE
    }
    teavm_local_3 = TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_numberLength);
    teavm_local_4 = TEAVM_FIELD(teavm_local_1, cls_jm_BigInteger, fld_numberLength);
    teavm_local_5 = teavm_compare_i32(teavm_local_3, teavm_local_4);
    if ((!teavm_local_5)) {
        teavm_local_6 = TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_digits);
        teavm_local_7 = TEAVM_FIELD(teavm_local_1, cls_jm_BigInteger, fld_digits);
        TEAVM_GC_ROOT(INT32_C(0), teavm_local_1);
        TEAVM_GC_ROOT(INT32_C(1), teavm_local_6);
        TEAVM_GC_ROOT(INT32_C(2), teavm_local_7);
        teavm_local_5 = TEAVM_WITH_CALL_SITE_ID(9763, meth_jm_Elementary_compareArrays(teavm_local_6, teavm_local_7, teavm_local_3));
    } else {
        teavm_local_5 = ((teavm_local_5 <= INT32_C(0)) ? -INT32_C(1) : INT32_C(1));
    }
    if ((teavm_local_5 != -INT32_C(1))) {
        TEAVM_GC_ROOT(INT32_C(0), teavm_local_1);
        teavm_local_8 = TEAVM_WITH_CALL_SITE_ID(9764, meth_otr_Allocator_allocateArray(&Arr_I_Cls, teavm_local_4));
        if ((teavm_local_4 != INT32_C(1))) {
            teavm_local_9 = ((teavm_local_3 - teavm_local_4) + INT32_C(1));
            teavm_local_2 = NULL;
            teavm_local_6 = TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_digits);
            teavm_local_7 = TEAVM_FIELD(teavm_local_1, cls_jm_BigInteger, fld_digits);
            TEAVM_GC_ROOT(INT32_C(0), teavm_local_6);
            TEAVM_GC_ROOT(INT32_C(1), teavm_local_7);
            teavm_local_8 = TEAVM_WITH_CALL_SITE_ID(9765, meth_jm_Division_divide(teavm_local_2, teavm_local_9, teavm_local_6, teavm_local_3, teavm_local_7, teavm_local_4));
        } else {
            teavm_local_10 = teavm_local_8;
            teavm_local_7 = TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_digits);
            teavm_local_6 = TEAVM_FIELD(teavm_local_1, cls_jm_BigInteger, fld_digits);
            TEAVM_GC_ROOT(INT32_C(0), teavm_local_10);
            TEAVM_GC_ROOT(INT32_C(1), teavm_local_7);
            TEAVM_GC_ROOT(INT32_C(2), teavm_local_6);
            teavm_local_6 = TEAVM_WITH_CALL_SITE_ID(9766, teavm_nullCheck(teavm_local_6));
            teavm_local_11 = TEAVM_ARRAY_AT(teavm_local_6, int32_t, TEAVM_WITH_CALL_SITE_ID(9767, teavm_checkUpperBound(INT32_C(0), teavm_local_6)));
            TEAVM_GC_ROOT_RELEASE(INT32_C(2));
            teavm_local_11 = TEAVM_WITH_CALL_SITE_ID(9768, meth_jm_Division_remainderArrayByInt(teavm_local_7, teavm_local_3, teavm_local_11));
            TEAVM_GC_ROOT_RELEASE(INT32_C(1));
            TEAVM_ARRAY_AT(teavm_local_10, int32_t, TEAVM_WITH_CALL_SITE_ID(9769, teavm_checkUpperBound(INT32_C(0), teavm_local_10))) = teavm_local_11;
        }
        TEAVM_GC_ROOT(INT32_C(0), teavm_local_8);
        teavm_local_12 = TEAVM_WITH_CALL_SITE_ID(9770, meth_otr_Allocator_allocate(&jm_BigInteger_Cls));
        teavm_local_13 = TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_sign);
        TEAVM_GC_ROOT(INT32_C(1), teavm_local_12);
        TEAVM_WITH_CALL_SITE_ID(9771, meth_jm_BigInteger__init_(teavm_local_12, teavm_local_13, teavm_local_4, teavm_local_8));
        TEAVM_GC_ROOT_RELEASE(INT32_C(0));
        TEAVM_WITH_CALL_SITE_ID(9772, meth_jm_BigInteger_cutOffLeadingZeroes(teavm_local_12));
        teavm_this_ = teavm_local_12;
    }
    TEAVM_RELEASE_STACK;
    return teavm_this_;
}
void meth_jm_BigInteger_cutOffLeadingZeroes(void* teavm_this_) {
    TeaVM_Array* teavm_local_1;
    int32_t teavm_local_2;
    int32_t teavm_local_3;
    TEAVM_ALLOC_STACK(INT32_C(1));
    while (1) {
        if (!(TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_numberLength) > INT32_C(0))) break;
        teavm_local_1 = TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_digits);
        teavm_local_2 = (TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_numberLength) - INT32_C(1));
        TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_numberLength) = teavm_local_2;
        TEAVM_GC_ROOT(INT32_C(0), teavm_local_1);
        teavm_local_1 = TEAVM_WITH_CALL_SITE_ID(9773, teavm_nullCheck(teavm_local_1));
        if (TEAVM_ARRAY_AT(teavm_local_1, int32_t, TEAVM_WITH_CALL_SITE_ID(9774, teavm_checkBounds(teavm_local_2, teavm_local_1)))) {
            goto teavm_label_1;
        }
    }
teavm_label_1:;
    teavm_local_1 = TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_digits);
    teavm_local_3 = TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_numberLength);
    TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_numberLength) = (teavm_local_3 + INT32_C(1));
    TEAVM_GC_ROOT(INT32_C(0), teavm_local_1);
    teavm_local_1 = TEAVM_WITH_CALL_SITE_ID(9775, teavm_nullCheck(teavm_local_1));
    if ((!TEAVM_ARRAY_AT(teavm_local_1, int32_t, TEAVM_WITH_CALL_SITE_ID(9776, teavm_checkBounds(teavm_local_3, teavm_local_1))))) {
        TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_sign) = INT32_C(0);
    }
    TEAVM_RELEASE_STACK;
}
int32_t meth_jm_BigInteger_isOne(void* teavm_this_) {
    TeaVM_Array* teavm_local_1;
    int32_t teavm_local_2;
    TEAVM_ALLOC_STACK(INT32_C(1));
    if ((TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_numberLength) == INT32_C(1))) {
        teavm_local_1 = TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_digits);
        TEAVM_GC_ROOT(INT32_C(0), teavm_local_1);
        teavm_local_1 = TEAVM_WITH_CALL_SITE_ID(9777, teavm_nullCheck(teavm_local_1));
        if ((TEAVM_ARRAY_AT(teavm_local_1, int32_t, TEAVM_WITH_CALL_SITE_ID(9778, teavm_checkUpperBound(INT32_C(0), teavm_local_1))) == INT32_C(1))) {
            teavm_local_2 = INT32_C(1);
            goto teavm_label_1;
        }
    }
    teavm_local_2 = INT32_C(0);
teavm_label_1:;
    TEAVM_RELEASE_STACK;
    return teavm_local_2;
}
int32_t meth_jm_BigInteger_getFirstNonzeroDigit(void* teavm_this_) {
    int32_t teavm_local_1;
    TeaVM_Array* teavm_local_2;
    int32_t teavm_local_3;
    TEAVM_ALLOC_STACK(INT32_C(1));
    if ((TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_firstNonzeroDigit) == -INT32_C(2))) {
        if ((!TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_sign))) {
            teavm_local_1 = -INT32_C(1);
        } else {
            teavm_local_1 = INT32_C(0);
            while (1) {
                teavm_local_2 = TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_digits);
                TEAVM_GC_ROOT(INT32_C(0), teavm_local_2);
                teavm_local_2 = TEAVM_WITH_CALL_SITE_ID(9779, teavm_nullCheck(teavm_local_2));
                teavm_local_1 = TEAVM_WITH_CALL_SITE_ID(9780, teavm_checkBounds(teavm_local_1, teavm_local_2));
                if (TEAVM_ARRAY_AT(teavm_local_2, int32_t, teavm_local_1)) {
                    goto teavm_label_1;
                }
                teavm_local_1 = (teavm_local_1 + INT32_C(1));
            }
        teavm_label_1:;
        }
        TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_firstNonzeroDigit) = teavm_local_1;
    }
    teavm_local_3 = TEAVM_FIELD(teavm_this_, cls_jm_BigInteger, fld_firstNonzeroDigit);
    TEAVM_RELEASE_STACK;
    return teavm_local_3;
}
void* meth_jm_BigInteger_getPowerOfTwo(int32_t teavm_local_1) {
    TeaVM_Array* teavm_local_2;
    void* teavm_local_3;
    int32_t teavm_local_4;
    int32_t teavm_local_5;
    int32_t teavm_local_6;
    TeaVM_Array* teavm_local_7;
    int32_t teavm_local_8;
    TEAVM_ALLOC_STACK(INT32_C(2));
    if ((!(((TeaVM_Class *) &jm_BigInteger_Cls)->flags & INT32_C(1)))) {
        TEAVM_GC_ROOT_RELEASE(INT32_C(0));
        TEAVM_GC_ROOT_RELEASE(INT32_C(1));
        TEAVM_WITH_CALL_SITE_ID(9781, initclass_jm_BigInteger());
    }
    teavm_local_2 = sfld_jm_BigInteger_TWO_POWS;
    TEAVM_GC_ROOT(INT32_C(0), teavm_local_2);
    TEAVM_GC_ROOT_RELEASE(INT32_C(1));
    if ((teavm_local_1 < TEAVM_ARRAY_LENGTH(TEAVM_WITH_CALL_SITE_ID(9782, teavm_nullCheck(teavm_local_2))))) {
        teavm_local_2 = sfld_jm_BigInteger_TWO_POWS;
        TEAVM_GC_ROOT(INT32_C(0), teavm_local_2);
        teavm_local_2 = TEAVM_WITH_CALL_SITE_ID(9783, teavm_nullCheck(teavm_local_2));
        teavm_local_1 = TEAVM_WITH_CALL_SITE_ID(9784, teavm_checkBounds(teavm_local_1, teavm_local_2));
        teavm_local_3 = TEAVM_ARRAY_AT(teavm_local_2, void*, teavm_local_1);
    } else {
        teavm_local_4 = (teavm_local_1 >> INT32_C(5));
        teavm_local_5 = (teavm_local_1 & INT32_C(31));
        teavm_local_6 = (teavm_local_4 + INT32_C(1));
        TEAVM_GC_ROOT_RELEASE(INT32_C(0));
        teavm_local_7 = TEAVM_WITH_CALL_SITE_ID(9785, meth_otr_Allocator_allocateArray(&Arr_I_Cls, teavm_local_6));
        teavm_local_2 = teavm_local_7;
        teavm_local_8 = (INT32_C(1) << teavm_local_5);
        TEAVM_GC_ROOT(INT32_C(0), teavm_local_2);
        teavm_local_4 = TEAVM_WITH_CALL_SITE_ID(9786, teavm_checkBounds(teavm_local_4, teavm_local_2));
        TEAVM_ARRAY_AT(teavm_local_2, int32_t, teavm_local_4) = teavm_local_8;
        teavm_local_3 = TEAVM_WITH_CALL_SITE_ID(9787, meth_otr_Allocator_allocate(&jm_BigInteger_Cls));
        TEAVM_GC_ROOT(INT32_C(1), teavm_local_3);
        TEAVM_WITH_CALL_SITE_ID(9788, meth_jm_BigInteger__init_(teavm_local_3, INT32_C(1), teavm_local_6, teavm_local_7));
    }
    TEAVM_RELEASE_STACK;
    return teavm_local_3;
}
void meth_jm_BigInteger__clinit_() {
    void* teavm_local_1;
    TeaVM_Array* teavm_local_2;
    TeaVM_Array* teavm_local_3;
    int32_t teavm_local_4;
    int64_t teavm_local_5;
    TEAVM_ALLOC_STACK(INT32_C(2));
    TEAVM_GC_ROOT_RELEASE(INT32_C(0));
    TEAVM_GC_ROOT_RELEASE(INT32_C(1));
    teavm_local_1 = TEAVM_WITH_CALL_SITE_ID(9789, meth_otr_Allocator_allocate(&jm_BigInteger_Cls));
    TEAVM_GC_ROOT(INT32_C(0), teavm_local_1);
    TEAVM_WITH_CALL_SITE_ID(9790, meth_jm_BigInteger__init__0(teavm_local_1, INT32_C(0), INT32_C(0)));
    sfld_jm_BigInteger_ZERO = teavm_local_1;
    TEAVM_GC_ROOT_RELEASE(INT32_C(0));
    teavm_local_1 = TEAVM_WITH_CALL_SITE_ID(9791, meth_otr_Allocator_allocate(&jm_BigInteger_Cls));
    TEAVM_GC_ROOT(INT32_C(0), teavm_local_1);
    TEAVM_WITH_CALL_SITE_ID(9792, meth_jm_BigInteger__init__0(teavm_local_1, INT32_C(1), INT32_C(1)));
    sfld_jm_BigInteger_ONE = teavm_local_1;
    TEAVM_GC_ROOT_RELEASE(INT32_C(0));
    teavm_local_1 = TEAVM_WITH_CALL_SITE_ID(9793, meth_otr_Allocator_allocate(&jm_BigInteger_Cls));
    TEAVM_GC_ROOT(INT32_C(0), teavm_local_1);
    TEAVM_WITH_CALL_SITE_ID(9794, meth_jm_BigInteger__init__0(teavm_local_1, INT32_C(1), INT32_C(2)));
    sfld_jm_BigInteger_TWO = teavm_local_1;
    TEAVM_GC_ROOT_RELEASE(INT32_C(0));
    teavm_local_1 = TEAVM_WITH_CALL_SITE_ID(9795, meth_otr_Allocator_allocate(&jm_BigInteger_Cls));
    TEAVM_GC_ROOT(INT32_C(0), teavm_local_1);
    TEAVM_WITH_CALL_SITE_ID(9796, meth_jm_BigInteger__init__0(teavm_local_1, INT32_C(1), INT32_C(10)));
    sfld_jm_BigInteger_TEN = teavm_local_1;
    TEAVM_GC_ROOT_RELEASE(INT32_C(0));
    teavm_local_1 = TEAVM_WITH_CALL_SITE_ID(9797, meth_otr_Allocator_allocate(&jm_BigInteger_Cls));
    TEAVM_GC_ROOT(INT32_C(0), teavm_local_1);
    TEAVM_WITH_CALL_SITE_ID(9798, meth_jm_BigInteger__init__0(teavm_local_1, -INT32_C(1), INT32_C(1)));
    sfld_jm_BigInteger_MINUS_ONE = teavm_local_1;
    TEAVM_GC_ROOT_RELEASE(INT32_C(0));
    teavm_local_2 = TEAVM_WITH_CALL_SITE_ID(9799, meth_otr_Allocator_allocateArray(&Arr_jm_BigInteger_Cls, INT32_C(11)));
    teavm_local_3 = teavm_local_2;
    teavm_local_1 = sfld_jm_BigInteger_ZERO;
    teavm_gc_writeBarrier(teavm_local_3);
    TEAVM_ARRAY_AT(teavm_local_3, void*, INT32_C(0)) = teavm_local_1;
    TEAVM_ARRAY_AT(teavm_local_3, void*, INT32_C(1)) = sfld_jm_BigInteger_ONE;
    TEAVM_ARRAY_AT(teavm_local_3, void*, INT32_C(2)) = sfld_jm_BigInteger_TWO;
    TEAVM_GC_ROOT(INT32_C(0), teavm_local_3);
    teavm_local_1 = TEAVM_WITH_CALL_SITE_ID(9800, meth_otr_Allocator_allocate(&jm_BigInteger_Cls));
    TEAVM_GC_ROOT(INT32_C(1), teavm_local_1);
    TEAVM_WITH_CALL_SITE_ID(9801, meth_jm_BigInteger__init__0(teavm_local_1, INT32_C(1), INT32_C(3)));
    teavm_gc_writeBarrier(teavm_local_3);
    TEAVM_ARRAY_AT(teavm_local_3, void*, INT32_C(3)) = teavm_local_1;
    TEAVM_GC_ROOT_RELEASE(INT32_C(1));
    teavm_local_1 = TEAVM_WITH_CALL_SITE_ID(9802, meth_otr_Allocator_allocate(&jm_BigInteger_Cls));
    TEAVM_GC_ROOT(INT32_C(1), teavm_local_1);
    TEAVM_WITH_CALL_SITE_ID(9803, meth_jm_BigInteger__init__0(teavm_local_1, INT32_C(1), INT32_C(4)));
    teavm_gc_writeBarrier(teavm_local_3);
    TEAVM_ARRAY_AT(teavm_local_3, void*, INT32_C(4)) = teavm_local_1;
    TEAVM_GC_ROOT_RELEASE(INT32_C(1));
    teavm_local_1 = TEAVM_WITH_CALL_SITE_ID(9804, meth_otr_Allocator_allocate(&jm_BigInteger_Cls));
    TEAVM_GC_ROOT(INT32_C(1), teavm_local_1);
    TEAVM_WITH_CALL_SITE_ID(9805, meth_jm_BigInteger__init__0(teavm_local_1, INT32_C(1), INT32_C(5)));
    teavm_gc_writeBarrier(teavm_local_3);
    TEAVM_ARRAY_AT(teavm_local_3, void*, INT32_C(5)) = teavm_local_1;
    TEAVM_GC_ROOT_RELEASE(INT32_C(1));
    teavm_local_1 = TEAVM_WITH_CALL_SITE_ID(9806, meth_otr_Allocator_allocate(&jm_BigInteger_Cls));
    TEAVM_GC_ROOT(INT32_C(1), teavm_local_1);
    TEAVM_WITH_CALL_SITE_ID(9807, meth_jm_BigInteger__init__0(teavm_local_1, INT32_C(1), INT32_C(6)));
    teavm_gc_writeBarrier(teavm_local_3);
    TEAVM_ARRAY_AT(teavm_local_3, void*, INT32_C(6)) = teavm_local_1;
    TEAVM_GC_ROOT_RELEASE(INT32_C(1));
    teavm_local_1 = TEAVM_WITH_CALL_SITE_ID(9808, meth_otr_Allocator_allocate(&jm_BigInteger_Cls));
    TEAVM_GC_ROOT(INT32_C(1), teavm_local_1);
    TEAVM_WITH_CALL_SITE_ID(9809, meth_jm_BigInteger__init__0(teavm_local_1, INT32_C(1), INT32_C(7)));
    teavm_gc_writeBarrier(teavm_local_3);
    TEAVM_ARRAY_AT(teavm_local_3, void*, INT32_C(7)) = teavm_local_1;
    TEAVM_GC_ROOT_RELEASE(INT32_C(1));
    teavm_local_1 = TEAVM_WITH_CALL_SITE_ID(9810, meth_otr_Allocator_allocate(&jm_BigInteger_Cls));
    TEAVM_GC_ROOT(INT32_C(1), teavm_local_1);
    TEAVM_WITH_CALL_SITE_ID(9811, meth_jm_BigInteger__init__0(teavm_local_1, INT32_C(1), INT32_C(8)));
    teavm_gc_writeBarrier(teavm_local_3);
    TEAVM_ARRAY_AT(teavm_local_3, void*, INT32_C(8)) = teavm_local_1;
    TEAVM_GC_ROOT_RELEASE(INT32_C(1));
    teavm_local_1 = TEAVM_WITH_CALL_SITE_ID(9812, meth_otr_Allocator_allocate(&jm_BigInteger_Cls));
    TEAVM_GC_ROOT(INT32_C(1), teavm_local_1);
    TEAVM_WITH_CALL_SITE_ID(9813, meth_jm_BigInteger__init__0(teavm_local_1, INT32_C(1), INT32_C(9)));
    teavm_gc_writeBarrier(teavm_local_3);
    TEAVM_ARRAY_AT(teavm_local_3, void*, INT32_C(9)) = teavm_local_1;
    TEAVM_ARRAY_AT(teavm_local_3, void*, INT32_C(10)) = sfld_jm_BigInteger_TEN;
    sfld_jm_BigInteger_SMALL_VALUES = teavm_local_2;
    TEAVM_GC_ROOT_RELEASE(INT32_C(0));
    TEAVM_GC_ROOT_RELEASE(INT32_C(1));
    sfld_jm_BigInteger_TWO_POWS = TEAVM_WITH_CALL_SITE_ID(9814, meth_otr_Allocator_allocateArray(&Arr_jm_BigInteger_Cls, INT32_C(32)));
    teavm_local_4 = INT32_C(0);
    while (1) {
        teavm_local_2 = sfld_jm_BigInteger_TWO_POWS;
        TEAVM_GC_ROOT(INT32_C(0), teavm_local_2);
        if ((teavm_local_4 >= TEAVM_ARRAY_LENGTH(TEAVM_WITH_CALL_SITE_ID(9815, teavm_nullCheck(teavm_local_2))))) {
            goto teavm_label_1;
        }
        teavm_local_2 = sfld_jm_BigInteger_TWO_POWS;
        teavm_local_5 = (INT64_C(1) << teavm_local_4);
        TEAVM_GC_ROOT(INT32_C(0), teavm_local_2);
        teavm_local_1 = TEAVM_WITH_CALL_SITE_ID(9816, meth_jm_BigInteger_valueOf(teavm_local_5));
        TEAVM_GC_ROOT(INT32_C(1), teavm_local_1);
        teavm_local_2 = TEAVM_WITH_CALL_SITE_ID(9817, teavm_nullCheck(teavm_local_2));
        teavm_local_4 = TEAVM_WITH_CALL_SITE_ID(9818, teavm_checkBounds(teavm_local_4, teavm_local_2));
        teavm_gc_writeBarrier(teavm_local_2);
        TEAVM_ARRAY_AT(teavm_local_2, void*, teavm_local_4) = teavm_local_1;
        teavm_local_4 = (teavm_local_4 + INT32_C(1));
    }
teavm_label_1:;
    TEAVM_RELEASE_STACK;
}
void initclass_jm_BigInteger() {
    TeaVM_Class* cls = (TeaVM_Class*) &jm_BigInteger_Cls;
    if (!(cls->flags & INT32_C(1))) {
        cls->flags |= INT32_C(1);
        meth_jm_BigInteger__clinit_();
    }
}
int32_t supertypeof_jm_BigInteger(TeaVM_Class* cls) {
    int32_t tag = cls->tag;
    if (tag < 1848 || tag >= 1850) return INT32_C(0);
    return INT32_C(1);
}
static int16_t teavm_classLayouts_jm_BigInteger_Cls[2];
alignas(8) jm_BigInteger_VT jm_BigInteger_Cls = {
    .parent = {
        .size = (int32_t) (intptr_t) TEAVM_ALIGN(sizeof(cls_jm_BigInteger), sizeof(void*)),
        .flags = 0,
        .tag = 1848,
        .canary = 0,
        .name = NULL,
        .simpleName = NULL,
        .arrayType = (TeaVM_Class*) &Arr_jm_BigInteger_Cls,
        .itemType = NULL,
        .isSupertypeOf = &supertypeof_jm_BigInteger,
        .superclass = (TeaVM_Class*) &jl_Number_Cls,
        .superinterfaceCount = 2,
        .superinterfaces = (TeaVM_Class*[]) { (TeaVM_Class*) &jl_Comparable_Cls, (TeaVM_Class*) &ji_Serializable_Cls },
        .layout = teavm_classLayouts_jm_BigInteger_Cls,
        .enumValues = NULL,
        .declaringClass = NULL,
        .enclosingClass = NULL,
        .init = initclass_jm_BigInteger
    },
    .virt_hashCode = &meth_jl_Object_hashCode,
    .virt_equals = &meth_jm_BigInteger_equals,
    .virt_clone = &meth_jl_Object_clone,
    .virt_toString = &meth_jl_Object_toString,
    .virt_isEmptyMonitor = &meth_jl_Object_isEmptyMonitor,
    .virt_getClass = &meth_jl_Object_getClass,
    .virt_identity = &meth_jl_Object_identity,
    .virt_intValue = &meth_jm_BigInteger_intValue,
    .virt_doubleValue = &meth_jm_BigInteger_doubleValue,
    .virt_longValue = &meth_jm_BigInteger_longValue,
    .virt_byteValue = &meth_jl_Number_byteValue,
    .virt_isOne = &meth_jm_BigInteger_isOne,
    .virt_bitLength = &meth_jm_BigInteger_bitLength,
    .virt_remainder = &meth_jm_BigInteger_remainder,
    .virt_getFirstNonzeroDigit = &meth_jm_BigInteger_getFirstNonzeroDigit,
    .virt_divideAndRemainder = &meth_jm_BigInteger_divideAndRemainder,
    .virt_shiftRight = &meth_jm_BigInteger_shiftRight,
    .virt_signum = &meth_jm_BigInteger_signum,
    .virt_shiftLeft = &meth_jm_BigInteger_shiftLeft,
    .virt_multiply = &meth_jm_BigInteger_multiply,
    .virt_equalsArrays = &meth_jm_BigInteger_equalsArrays,
    .virt_add_6 = &meth_jm_BigInteger_add,
    .virt_testBit = &meth_jm_BigInteger_testBit,
    .virt_abs = &meth_jm_BigInteger_abs,
    .virt_negate = &meth_jm_BigInteger_negate,
    .virt_cutOffLeadingZeroes = &meth_jm_BigInteger_cutOffLeadingZeroes,
    .virt_divide = &meth_jm_BigInteger_divide,
    .virt_subtract = &meth_jm_BigInteger_subtract,
    .virt_compareTo_0 = &meth_jm_BigInteger_compareTo,
    .virt_pow = &meth_jm_BigInteger_pow
};
static void** teavm_gc_localStaticRoots_jm_BigInteger_Cls[7] = {
(void**) &sfld_jm_BigInteger_ZERO, (void**) &sfld_jm_BigInteger_ONE, (void**) &sfld_jm_BigInteger_TWO, (void**) &sfld_jm_BigInteger_TEN, (void**) &sfld_jm_BigInteger_MINUS_ONE, (void**) &sfld_jm_BigInteger_SMALL_VALUES, (void**) &sfld_jm_BigInteger_TWO_POWS
};
static int16_t teavm_classLayouts_jm_BigInteger_Cls[2] = {
INT16_C(1), (int16_t) offsetof(cls_jm_BigInteger, fld_digits)
};
void sysinitclass_jm_BigInteger() {
sfld_jm_BigInteger_ZERO = NULL;
sfld_jm_BigInteger_ONE = NULL;
sfld_jm_BigInteger_TWO = NULL;
sfld_jm_BigInteger_TEN = NULL;
sfld_jm_BigInteger_MINUS_ONE = NULL;
sfld_jm_BigInteger_SMALL_VALUES = NULL;
sfld_jm_BigInteger_TWO_POWS = NULL;
teavm_registerStaticGcRoots(teavm_gc_localStaticRoots_jm_BigInteger_Cls, 7);
}
